
clear*
set more off

cd "---"

* Note: in the regressions we are including group FE

global covariates1 work age single education ethnic_punjabi ethnic_pashtun ethnic_baluchi ethnic_urdu ethnic_seraiki religion_shia religion_sunnni religion_muslim  openness conscientiousness extroversion agreeableness neuroticism 

global covariates2 work age single education muslim openness conscientiousness extroversion agreeableness neuroticism 



************************************************************************************
******************************** Table 1 *******************************************
************************************************************************************

use  experiment1, clear


mat T1=J(60,12,.)

local row=1


gen LUMS_low_pri = us_donor==0 & high==0 & private==0
gen LUMS_low_pub = us_donor==0 & high==0 & private==1

gen LUMS_high_pri = us_donor==0 & high==1 & private==0
gen LUMS_high_pub = us_donor==0 & high==1 & private==1

gen US_low_pri = us_donor==1 & high==0 & private==0
gen US_low_pub = us_donor==1 & high==0 & private==1

gen US_high_pri = us_donor==1 & high==1 & private==0
gen US_high_pub = us_donor==1 & high==1 & private==1



foreach var of varlist $covariates1  {

	reg `var' LUMS* US* , cluster(group) noc

	local col=3
	foreach x in LUMS_low_pri   LUMS_low_pub   LUMS_high_pri   LUMS_high_pub   US_low_pri   US_low_pub   US_high_pri   US_high_pub {
		mat T1[`row',`col'] = _b[`x']
		mat T1[`row'+1,`col'] = _se[`x']
		
		local ++col
	}

	test LUMS_low_pri= LUMS_low_pub= LUMS_high_pri= LUMS_high_pub= US_low_pri= US_low_pub= US_high_pri= US_high_pub
			mat T1[`row',`col'] = r(p)

	summ `var'
		mat T1[`row',1] = r(mean)
		mat T1[`row'+1,1] = r(sd)

	




local ++row
local ++row
local ++row

}

mat li T1


************************************************************************************
******************************** Table 2 *******************************************
************************************************************************************


use  experiment1, clear


mat T=J(34,3,.)

gen C000 = high==0 & public==0 & us_donor==0
gen C001 = high==0 & public==0 & us_donor==1
gen C010 = high==0 & public==1 & us_donor==0
gen C011 = high==0 & public==1 & us_donor==1
gen C100 = high==1 & public==0 & us_donor==0
gen C101 = high==1 & public==0 & us_donor==1
gen C110 = high==1 & public==1 & us_donor==0
gen C111 = high==1 & public==1 & us_donor==1


reg rejected C*, cluster(group) noc 

**** Panel A: low payment

	* Private

	mat T[1,1] = _b[C001]
	mat T[2,1] = _se[C001]

	mat T[1,2] = _b[C000]
	mat T[2,2] = _se[C000]

	lincom C001 - C000

	mat T[1,3] = r(estimate)
	mat T[2,3] = r(se)

	* Public

	mat T[4,1] = _b[C011]
	mat T[5,1] = _se[C011]

	mat T[4,2] = _b[C010]
	mat T[5,2] = _se[C010]

	lincom C011 - C010

	mat T[4,3] = r(estimate)
	mat T[5,3] = r(se)

	* Difference
	
	lincom C001 - C011
	mat T[7,1] = r(estimate)
	mat T[8,1] = r(se)
	
	lincom C000 - C010
	mat T[7,2] = r(estimate)
	mat T[8,2] = r(se)
	
	lincom (C001 - C000) - (C011 - C010) 
	mat T[7,3] = r(estimate)
	mat T[8,3] = r(se)	
	
	
**** Panel B: high payment

	* Private

	mat T[13,1] = _b[C101]
	mat T[14,1] = _se[C101]

	mat T[13,2] = _b[C100]
	mat T[14,2] = _se[C100]

	lincom C101 - C100

	mat T[13,3] = r(estimate)
	mat T[14,3] = r(se)

	* Public

	mat T[16,1] = _b[C111]
	mat T[17,1] = _se[C111]

	mat T[16,2] = _b[C110]
	mat T[17,2] = _se[C110]

	lincom C111 - C110

	mat T[16,3] = r(estimate)
	mat T[17,3] = r(se)

	* Difference
	
	lincom C101 - C111
	mat T[19,1] = r(estimate)
	mat T[20,1] = r(se)
	
	lincom C100 - C110
	mat T[19,2] = r(estimate)
	mat T[20,2] = r(se)
	
	lincom (C101 - C100) - (C111 - C110) 
	mat T[19,3] = r(estimate)
	mat T[20,3] = r(se)	
		
	
**** Panel C: difference (low - high)

	* Private

	lincom C001 - C101
	
	mat T[25,1] = r(estimate)
	mat T[26,1] = r(se)

	lincom C000 - C100
	
	mat T[25,2] = r(estimate)
	mat T[26,2] = r(se)
	
	lincom (C001 - C101) - (C000 - C100)

	mat T[25,3] = r(estimate)
	mat T[26,3] = r(se)

	* Public

	lincom C011 - C111
	
	mat T[28,1] = r(estimate)
	mat T[29,1] = r(se)

	lincom C010 - C110
	
	mat T[28,2] = r(estimate)
	mat T[29,2] = r(se)
	
	lincom (C011 - C111) - (C010 - C110)

	mat T[28,3] = r(estimate)
	mat T[29,3] = r(se)
	
	

	* Difference
	
	lincom (C001 - C101) - (C011 - C111) 
	
	mat T[31,1] = r(estimate)
	mat T[32,1] = r(se)

	lincom (C000 - C100) - (C010 - C110)
	
	mat T[31,2] = r(estimate)
	mat T[32,2] = r(se)
	
	lincom ((C001 - C101) - (C011 - C111)) - ((C000 - C100) - (C010 - C110))

	mat T[31,3] = r(estimate)
	mat T[32,3] = r(se)
	
	
mat li T



************************************************************************************
******************************** Table 3 *******************************************
************************************************************************************




use  experiment1, clear
gen experiment1=1
gen ID=_n*1000000 // we just need to define that so that the cluster(ID) option works

append using  experiment2
replace experiment1=0 if experiment1==.

replace stage1=0 if stage1==.
replace stage2=0 if stage2==.

gen group_revealed = version==2
gen group_stated = version==1


mat T=J(80,12,.)

local row=1

foreach var of varlist  $covariates2  {

	reg `var' experiment1 stage1 stage2 , cluster(ID) robust noc

	mat T[`row',1] = _b[experiment1]
	mat T[`row'+1,1] = _se[experiment1]
	
	mat T[`row',3] = _b[stage1]
	mat T[`row'+1,3] = _se[stage1]

	mat T[`row',4] = _b[stage2]
	mat T[`row'+1,4] = _se[stage2]

	test stage1=stage2
	mat T[`row',9] = r(p)
	

	reg `var' group_stated group_revealed if stage2==1, cluster(ID) robust noc

	mat T[`row',6] = _b[group_revealed]
	mat T[`row'+1,6] = _se[group_revealed]

	mat T[`row',7] = _b[group_stated]
	mat T[`row'+1,7] = _se[group_stated]

	test group_stated = group_revealed
	mat T[`row',11] = r(p)
	

local ++row
local ++row
local ++row

}

mat li T




************************************************************************************
******************************** Table 4 *******************************************
************************************************************************************


use  experiment1, clear

keep if high==0 & public==0 & us_donor==1

gen y_1=e43<=2 
	replace y_1=. if e43==.

gen y_2=e44<=2 
	replace y_2=. if e44==.
	
mat R = J(10,2,.)
	
reg reject , cluster(group)
mat R[1,1] = _b[_c]
mat R[2,1] = _se[_c]
	
reg y_2 , cluster(group)
mat R[4,1] = _b[_c]
mat R[5,1] = _se[_c]
	
reg y_1, cluster(group)
mat R[7,1] = _b[_c]
mat R[8,1] = _se[_c]
	


use  experiment2, clear

reg reject 
mat R[1,2] = _b[_c]
mat R[2,2] = _se[_c]
	
reg negative_us_gov 
mat R[4,2] = _b[_c]
mat R[5,2] = _se[_c]
	
reg negative_aid
mat R[7,2] = _b[_c]
mat R[8,2] = _se[_c]
	

mat li R



************************************************************************************
******************************** Table 5 *******************************************
************************************************************************************


use  experiment1, clear

mat T=J(20,8,.)

gen y_1=e43<=2 
	replace y_1=. if e43==.

gen y_2=e44<=2 
	replace y_2=. if e44==.
	
	
gen y_3=e410<=2 
	replace y_3=. if e410==.

gen y_4=e49<=2 
	replace y_4=. if e49==. 
 
 
gen y_5=e41<=2 
	replace y_5=. if e41==.
	
gen y_6=e42<=2 
	replace y_6=. if e42==.


gen y_7=e47<=2 
	replace y_7=. if e47==.
	
gen y_8=e48<=2 
 	replace y_8=. if e48==.


local col=1
foreach var of varlist y_1-y_8  {

reg `var' rejected  if high==0 & us_donor==1 & private==1 , robust cluster(group)
	mat T[1,`col'] = _b[rejected]
	mat T[2,`col'] = _se[rejected]

	mat T[4,`col'] = _b[_cons]
	mat T[5,`col'] = _se[_cons]
	
	
	
	mat T[7,`col'] = e(N)



local ++col

}
 
mat li T 




************************************************************************************
******************************** Table A.1 *******************************************
************************************************************************************



use  experiment1, clear


mat T=J(34,3,.)

gen C000 = high==0 & public==0 & us_donor==0
gen C001 = high==0 & public==0 & us_donor==1
gen C010 = high==0 & public==1 & us_donor==0
gen C011 = high==0 & public==1 & us_donor==1
gen C100 = high==1 & public==0 & us_donor==0
gen C101 = high==1 & public==0 & us_donor==1
gen C110 = high==1 & public==1 & us_donor==0
gen C111 = high==1 & public==1 & us_donor==1

drop C000

reg rejected C* i.group $covariates1, robust cluster(group)

**** Panel A: low payment

	* Private

	mat T[1,3] = _b[C001]
	mat T[2,3] = _se[C001]

	* Public


	lincom C011 - C010

	mat T[4,3] = r(estimate)
	mat T[5,3] = r(se)

	* Difference
	
	lincom C001 - C011
	mat T[7,1] = r(estimate)
	mat T[8,1] = r(se)
	
	lincom  - C010
	mat T[7,2] = r(estimate)
	mat T[8,2] = r(se)
	
	lincom (C001 ) - (C011 - C010) 
	mat T[7,3] = r(estimate)
	mat T[8,3] = r(se)	
	
	
**** Panel B: high payment

	* Private

	lincom C101 - C100

	mat T[13,3] = r(estimate)
	mat T[14,3] = r(se)

	* Public


	lincom C111 - C110

	mat T[16,3] = r(estimate)
	mat T[17,3] = r(se)

	* Difference
	
	lincom C101 - C111
	mat T[19,1] = r(estimate)
	mat T[20,1] = r(se)
	
	lincom C100 - C110
	mat T[19,2] = r(estimate)
	mat T[20,2] = r(se)
	
	lincom (C101 - C100) - (C111 - C110) 
	mat T[19,3] = r(estimate)
	mat T[20,3] = r(se)	
		
	
**** Panel C: difference (low - high)

	* Private

	lincom C001 - C101
	
	mat T[25,1] = r(estimate)
	mat T[26,1] = r(se)

	lincom  - C100
	
	mat T[25,2] = r(estimate)
	mat T[26,2] = r(se)
	
	lincom (C001 - C101) - ( - C100)

	mat T[25,3] = r(estimate)
	mat T[26,3] = r(se)

	* Public

	lincom C011 - C111
	
	mat T[28,1] = r(estimate)
	mat T[29,1] = r(se)

	lincom C010 - C110
	
	mat T[28,2] = r(estimate)
	mat T[29,2] = r(se)
	
	lincom (C011 - C111) - (C010 - C110)

	mat T[28,3] = r(estimate)
	mat T[29,3] = r(se)
	
	

	* Difference
	
	lincom (C001 - C101) - (C011 - C111) 
	
	mat T[31,1] = r(estimate)
	mat T[32,1] = r(se)

	lincom ( - C100) - (C010 - C110)
	
	mat T[31,2] = r(estimate)
	mat T[32,2] = r(se)
	
	lincom ((C001 - C101) - (C011 - C111)) - (( - C100) - (C010 - C110))

	mat T[31,3] = r(estimate)
	mat T[32,3] = r(se)
	
	
	
	
	
mat li T




************************************************************************************
******************************** Table A.2 *******************************************
************************************************************************************


use  experiment2, clear


mat T=J(8,8,.)


reg pti_currently rejected , robust
	
	mat T[1,1]=_b[rejected]
	mat T[2,1]=_se[rejected]

	mat T[7,1]=e(N)	
	
reg pti_currently if rejected==0
	
	mat T[4,1]=_b[_cons]
	mat T[5,1]=_se[_cons]

	
reg pti_currently rejected  if party_currently==1, robust
	
	mat T[1,2]=_b[rejected]
	mat T[2,2]=_se[rejected]

	mat T[7,2]=e(N)	
	
reg pti_currently if rejected==0 & party_currently==1
	
	mat T[4,2]=_b[_cons]
	mat T[5,2]=_se[_cons]

	
	
	
	
	
	
	
reg pml_currently rejected , robust
	
	mat T[1,4]=_b[rejected]
	mat T[2,4]=_se[rejected]

	mat T[7,4]=e(N)	
	
reg pml_currently if rejected==0
	
	mat T[4,4]=_b[_cons]
	mat T[5,4]=_se[_cons]

			
	
	
reg pml_currently rejected  if party_currently==1, robust
	
	mat T[1,5]=_b[rejected]
	mat T[2,5]=_se[rejected]


	mat T[7,5]=e(N)	
	
reg pml_currently if rejected==0 & party_currently==1
	
	mat T[4,5]=_b[_cons]
	mat T[5,5]=_se[_cons]
	
	
	
	

reg pti_sign_up rejected , robust
	
	mat T[1,7]=_b[rejected]
	mat T[2,7]=_se[rejected]

	mat T[7,7]=e(N)	
	
reg pti_sign_up if rejected==0
	
	mat T[4,7]=_b[_cons]
	mat T[5,7]=_se[_cons]

		
	
	
	
reg pml_sign_up rejected , robust
	
	mat T[1,8]=_b[rejected]
	mat T[2,8]=_se[rejected]

	mat T[7,8]=e(N)	
	
reg pml_sign_up if rejected==0
	
	mat T[4,8]=_b[_cons]
	mat T[5,8]=_se[_cons]

	

mat li T



************************************************************************************
******************************** Table A.3 *******************************************
************************************************************************************



use  experiment2, clear


mat T=J(50,8,.)


local y="negative_aid"  // use first y="negative_us_gov" and then y="negative_aid"


reg pti_currently `y' , robust
	
	mat T[1,1]=_b[`y']
	mat T[2,1]=_se[`y']

	mat T[7,1]=e(N)	
	
reg pti_currently if `y'==0
	
	mat T[4,1]=_b[_cons]
	mat T[5,1]=_se[_cons]

	
reg pti_currently `y'  if party_currently==1, robust
	
	mat T[1,2]=_b[`y']
	mat T[2,2]=_se[`y']

	mat T[7,2]=e(N)	
	
reg pti_currently if `y'==0 & party_currently==1
	
	mat T[4,2]=_b[_cons]
	mat T[5,2]=_se[_cons]

	
reg pml_currently `y' , robust
	
	mat T[1,4]=_b[`y']
	mat T[2,4]=_se[`y']

	mat T[7,4]=e(N)	
	
reg pml_currently if `y'==0
	
	mat T[4,4]=_b[_cons]
	mat T[5,4]=_se[_cons]

			
	
	
reg pml_currently `y'  if party_currently==1, robust
	
	mat T[1,5]=_b[`y']
	mat T[2,5]=_se[`y']


	mat T[7,5]=e(N)	
	
reg pml_currently if `y'==0 & party_currently==1
	
	mat T[4,5]=_b[_cons]
	mat T[5,5]=_se[_cons]
	
	

reg pti_sign_up `y' , robust
	
	mat T[1,7]=_b[`y']
	mat T[2,7]=_se[`y']

	mat T[7,7]=e(N)	
	
reg pti_sign_up if `y'==0
	
	mat T[4,7]=_b[_cons]
	mat T[5,7]=_se[_cons]

		
	
reg pml_sign_up `y' , robust
	
	mat T[1,8]=_b[`y']
	mat T[2,8]=_se[`y']

	mat T[7,8]=e(N)	
	
reg pml_sign_up if `y'==0
	
	mat T[4,8]=_b[_cons]
	mat T[5,8]=_se[_cons]

	

mat li T





















